/*
 * Decompiled with CFR 0.152.
 */
package apicore.ptmp;

import apicore.ptmp.PacketTracerConnection;
import apicore.util.Logger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.StringTokenizer;

public class ConnectionNegotiationTask {
    protected PacketTracerConnection packetTracerConnection;

    public ConnectionNegotiationTask(PacketTracerConnection packetTracerConnection) {
        this.packetTracerConnection = packetTracerConnection;
    }

    public void negotiateConnection() throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(0);
        stringBuffer.append("\u0000");
        stringBuffer.append(this.packetTracerConnection.connectionNegotiationProperties().toMessage());
        StringBuffer stringBuffer2 = new StringBuffer();
        stringBuffer2.append(stringBuffer.toString().length());
        stringBuffer2.append("\u0000");
        stringBuffer2.append(stringBuffer.toString());
        ByteBuffer byteBuffer = ByteBuffer.allocate(128);
        byteBuffer.put(stringBuffer2.toString().getBytes());
        byteBuffer.flip();
        int n = this.packetTracerConnection.write(byteBuffer);
        if (Logger.isInfoEnabled()) {
            Logger.info("Connection negotiation task wrote # of bytes: [" + n + "]");
        }
        byteBuffer.clear();
        int n2 = this.packetTracerConnection.read(byteBuffer);
        if (Logger.isInfoEnabled()) {
            Logger.info("Connection negotiation task read # of bytes: [" + n2 + "]");
        }
        byteBuffer.flip();
        byte[] byArray = new byte[n2];
        for (int i = 0; i < n2; ++i) {
            byArray[i] = byteBuffer.get(i);
        }
        String string = new String(byArray);
        Logger.fine("response = <" + string + ">");
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\u0000");
        int n3 = stringTokenizer.countTokens();
        if (n3 == 11) {
            stringTokenizer.nextToken();
            stringTokenizer.nextToken();
            this.packetTracerConnection.connectionNegotiationProperties().setSignature(stringTokenizer.nextToken());
            this.packetTracerConnection.connectionNegotiationProperties().setVersion(Integer.parseInt(stringTokenizer.nextToken()));
            this.packetTracerConnection.connectionNegotiationProperties().setServerUid(stringTokenizer.nextToken());
            this.packetTracerConnection.connectionNegotiationProperties().setEncoding(Integer.parseInt(stringTokenizer.nextToken()));
            this.packetTracerConnection.connectionNegotiationProperties().setEncryption(Integer.parseInt(stringTokenizer.nextToken()));
            this.packetTracerConnection.connectionNegotiationProperties().setCompression(Integer.parseInt(stringTokenizer.nextToken()));
            this.packetTracerConnection.connectionNegotiationProperties().setAuthentication(Integer.parseInt(stringTokenizer.nextToken()));
            this.packetTracerConnection.connectionNegotiationProperties().setServerTimestamp(stringTokenizer.nextToken());
            this.packetTracerConnection.connectionNegotiationProperties().setKeepAlivePeriod(Integer.parseInt(stringTokenizer.nextToken()));
            if (Logger.isInfoEnabled()) {
                Logger.info("Successfully negotiated connection");
                Logger.info("with connection properties: [" + this.packetTracerConnection.connectionNegotiationProperties() + "]");
            }
        } else {
            if (n3 == 3) {
                stringTokenizer.nextToken();
                String string2 = stringTokenizer.nextToken();
                String string3 = stringTokenizer.nextToken();
                if (string2.equals("7")) {
                    string = string3;
                }
                Logger.error("Received invalid connection negotiation response: " + string);
            } else {
                Logger.error("Received invalid connection negotiation response");
                Logger.error("tokens = " + n3);
                for (int i = 0; i < n3; ++i) {
                    Logger.error("token[" + i + "] = <" + stringTokenizer.nextToken() + ">");
                }
            }
            throw new IOException("Connection negotiation failed: " + string);
        }
    }
}

